package org.matrix.socket.vo;

import cn.hutool.http.HttpStatus;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * socket的返回标准版
 * @author Administrator
 */
@Data
@AllArgsConstructor
public class SocketResponseMessage {

    private int code;

    private String message;

    public static String success(String message){
        return JSONObject.toJSONString(new SocketResponseMessage(HttpStatus.HTTP_OK,message));
    }

    /**
     * 慎用，假如返回500的话证明这个socket已经执行不下去了，假如时用例执行的时候，产生的错误日志请不要用这个fail抛出
     * @param message
     * @return
     */
    public static String fail(String message){
        return JSONObject.toJSONString(new SocketResponseMessage(HttpStatus.HTTP_INTERNAL_ERROR,message));
    }
}
