package org.matrix.actuators.http;

import cn.hutool.script.ScriptUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.JsonPath;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;

import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.actuators.usecase.TestDataExecuteResult;
import org.matrix.database.entity.TestCase;
import org.matrix.database.entity.TestCaseBTO;
import org.matrix.database.entity.TestData;
import org.matrix.database.service.IExecutionRecordService;
import org.matrix.database.service.ITestCaseService;
import org.matrix.database.service.ITestDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.script.ScriptEngine;
import javax.script.ScriptException;

@RunWith(SpringRunner.class)
@SpringBootTest
class CaseActuatorTest {

    @Autowired
    CaseActuator caseActuator;

    @Autowired
    IExecutionRecordService executionRecordService;

    @Autowired
    ITestCaseService iTestCaseService;

    @Autowired
    ITestDataService iTestDataService;

    @Test
    void testList(){
        // 测试任务ID.测试用例ID.测试数据ID.日志
//        String str1 = "-1.2.2.张三";
//        String str2 = "-1.2.2.李四";
//        String str3 = "-1.2.3.张三";
//        String str4 = "-1.2.3.张三";
//        List<ExecutionRecord> records = new ArrayList<>();

         TestCase byId = iTestCaseService.getById(3);
        System.out.println(JSONObject.toJSON(byId));
         TestData byId1 = iTestDataService.getById(3);
        System.out.println(JSONObject.toJSON(byId1));


//        String str1 = "2.张三";
//        String str2 = "2.李四";
//        String str3 = "3.张三";
//        String str4 = "3.张三";
//        JSONObject object = new JSONObject();
//        JSONArray jsonArray = new JSONArray();

    }

    @Test
    void jsonPathTest() throws ScriptException {
        String json = "{\n" +
                "    \"store\": {\n" +
                "        \"book\": [\n" +
                "            {\n" +
                "                \"category\": \"reference\",\n" +
                "                \"author\": \"Nigel Rees\",\n" +
                "                \"title\": \"Sayings of the Century\",\n" +
                "                \"price\": 8.95\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"Evelyn Waugh\",\n" +
                "                \"title\": \"Sword of Honour\",\n" +
                "                \"price\": 12.99\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"Herman Melville\",\n" +
                "                \"title\": \"Moby Dick\",\n" +
                "                \"isbn\": \"0-553-21311-3\",\n" +
                "                \"price\": 8.99\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"J. R. R. Tolkien\",\n" +
                "                \"title\": \"The Lord of the Rings\",\n" +
                "                \"isbn\": \"0-395-19395-8\",\n" +
                "                \"price\": 22.99\n" +
                "            }\n" +
                "        ],\n" +
                "        \"bicycle\": {\n" +
                "            \"color\": \"red\",\n" +
                "            \"price\": 19.95\n" +
                "        }\n" +
                "    },\n" +
                "    \"expensive\": 10\n" +
                "}\n" +
                "                        ";
        ScriptEngine jsEngine = ScriptUtil.createJsEngine();
        jsEngine.eval("//a跟b进行比较,对象类型分为以下几种:基础类型、数组、普通对象\n" +
                "function equal(a, b) {\n" +
                "    var aType = Object.prototype.toString.call(a);\n" +
                "    var bType = Object.prototype.toString.call(b);\n" +
                "    switch (aType) {\n" +
                "        case \"[object Array]\":\n" +
                "            //数组类型\n" +
                "            switch (bType) {\n" +
                "                case \"[object Array]\":\n" +
                "                    return JSON.stringify(a) === JSON.stringify(b);\n" +
                "                default:\n" +
                "                    for (var i = 0; i < a.length; i++) {\n" +
                "                        if (JSON.stringify(a[i]) !== JSON.stringify(b)) {\n" +
                "                            return false;\n" +
                "                        }\n" +
                "                    }\n" +
                "                    return true;\n" +
                "            }\n" +
                "            break\n" +
                "        default:\n" +
                "            //基础类型和对象类型\n" +
                "            switch (bType) {\n" +
                "                case \"[object Array]\":\n" +
                "                    return equal(b, a);\n" +
                "                default:\n" +
                "                    return JSON.stringify(a) === JSON.stringify(b)\n" +
                "            }\n" +
                "    }\n" +
                "    return JSON.stringify(a) === JSON.stringify(b)\n" +
                "}\n" +
                "\n" +
                "\n" +
                "function contains(sourceValue, compareValue) {\n" +
                "    var sourceValueType = Object.prototype.toString.call(sourceValue);\n" +
                "    var compareValueType = Object.prototype.toString.call(compareValue);\n" +
                "    if (sourceValueType === \"[object Object]\") {\n" +
                "        for (var i = 0; i < Object.keys(sourceValue).length; i++) {\n" +
                "            var souceKey = Object.keys(sourceValue)[i];\n" +
                "            if (equal(sourceValue[souceKey], compareValue)) {\n" +
                "                return true;\n" +
                "            };\n" +
                "        }\n" +
                "        return false;\n" +
                "    } else if (sourceValueType == \"[object Array]\") {\n" +
                "        switch (compareValueType) {\n" +
                "            //如果数组包含的话，需要a种全包含b种的参数,例如： [1,2,3]比[1,2]为true ,  [1,2,3]比[1,2,3,4]为false\n" +
                "            case \"[object Array]\":\n" +
                "                //如果compareValue的长度 大于 sourceValue 则一定不包含\n" +
                "                if (sourceValue.length < compareValue.length) {\n" +
                "                    return false;\n" +
                "                }\n" +
                "                for (var i = 0; i < compareValue.length; i++) {\n" +
                "                    var innerFlag = false;\n" +
                "                    for (var j = 0; j < sourceValue.length; j++) {\n" +
                "                        if (JSON.stringify(compareValue[i]) == JSON.stringify(sourceValue[j])) {\n" +
                "                            innerFlag = true;\n" +
                "                            break;\n" +
                "                        }\n" +
                "                    }\n" +
                "                    if (!innerFlag) {\n" +
                "                        return false;\n" +
                "                    }\n" +
                "                }\n" +
                "                return true;\n" +
                "            case \"[object Object]\":\n" +
                "                for (var i = 0; i < sourceValue.length; i++) {\n" +
                "                    if (JSON.stringify(sourceValue[i]) == JSON.stringify(compareValue) ) {\n" +
                "                        return true;\n" +
                "                    }\n" +
                "                }\n" +
                "                return false;\n" +
                "            default:\n" +
                "                return sourceValue.indexOf(compareValue)> -1 ? true : false;\n" +
                "        }\n" +
                "        return false;\n" +
                "    } else {\n" +
                "        return JSON.stringify(sourceValue).indexOf(JSON.stringify(compareValue)) > -1 ? true : false\n" +
                "    }\n" +
                "\n" +
                "}\n" +
                "\n" +
                "\n" +
                "function BaseEntity(value) {\n" +
                "    this.type = Object.prototype.toString.call(value);\n" +
                "    if (this.type != '[object Object]' && this.type != '[object Array]') {\n" +
                "        try {\n" +
                "            this.value = JSON.parse(value);\n" +
                "            this.type = Object.prototype.toString.call(this.value);\n" +
                "        } catch (error) {\n" +
                "            this.value = value;\n" +
                "        }\n" +
                "    } else {\n" +
                "        this.value = value;\n" +
                "    }\n" +
                "}\n" +
                "\n" +
                "BaseEntity.prototype.get = function (key) {\n" +
                "    return this.value[key]\n" +
                "}\n" +
                "\n" +
                "BaseEntity.prototype.length = function (key) {\n" +
                "    return this.value.length\n" +
                "}\n" +
                "\n" +
                "BaseEntity.prototype.contains = function (key) {\n" +
                "    if(key instanceof BaseEntity){\n" +
                "        return contains(this.value,key.value)\n" +
                "    }else{\n" +
                "        return contains(this.value,key)\n" +
                "    }\n" +
                "}\n" +
                "\n" +
                "BaseEntity.prototype.equal = function (key) {\n" +
                "    if(key instanceof BaseEntity){\n" +
                "        return equal(this.value,key.value)\n" +
                "    }else{\n" +
                "        return equal(this.value,key)\n" +
                "    }\n" +
                "}\n" +
                "\n" +
                "var a = new BaseEntity('{\"name\":1,\"age\":2}');\n" +
                "var b = new BaseEntity('{\"name\":1,\"age\":3}');\n" +
                "\n");
        Object read = JsonPath.parse(json).read("$.store.bicycle.color");
        Object eval = jsEngine.eval(JSON.toJSONString(read) + ".length()");


        System.out.println("1");
    }




    @Test
    void test(){
        String json = "{\n" +
                "    \"url\":\"http://127.0.0.1:8080/test/sendMessage\",\n" +
                "    \"method\":\"GET\",\n" +
                "    \"requestType\":\"QUERY\",\n" +
                "    \"headers\":[\n" +
                "        {\n" +
                "            \"name\":\"cookie\",\n" +
                "            \"value\":\"123456\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"requestBodies\":[\n" +
                "        {\n" +
                "            \"key\":\"tableName\",\n" +
                "            \"type\":\"TEXT\",\n" +
                "            \"value\":\"张三\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        System.out.println(json);
        TestCase testCase = new TestCase();
        testCase.setName("name");
        testCase.setType(1);
        TestData testData = new TestData();
        testData.setDetail(json);
        testData.setAbnormalCheckpoint(1);
        testData.setContainCheckpoint("张三,李四");
        testData.setNoContainCheckpoint("张三,李四");
        testData.setJsonpathCheckpoint("contains({$..category},'${componentName}[0]')");
        TestCaseBTO testCaseBTO = new TestCaseBTO();
        testCaseBTO.setTestCase(testCase);
        testCaseBTO.setTestData(testData);
        TestDataExecuteResult testDataExecuteResult = caseActuator.executeTestCase(testCaseBTO,1L,1L);
        System.out.println(testDataExecuteResult);


    }

}
