package org.matrix.actuators.httpclient;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * RequestParam. 用于复合参数
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/4/24 at 4:48 PM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RequestParam {

    @ApiModelProperty("请求类型")
    private HttpRequestType requestType = HttpRequestType.NONE;

    @ApiModelProperty("键值对入参")
    private List<RequestBody> requestBodies = new ArrayList<>();
}
