package org.matrix.actuators.usecase;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Duration;
import java.time.LocalDateTime;

/**
 * 为其他需要计算时间的类提供公共服务
 *
 * @author huangxiahao
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BaseTime {

    LocalDateTime startTime;

    LocalDateTime endTime;

    public Long getDurationTimeMillis() {
        Duration duration = Duration.between(startTime, endTime);
        return duration.toMillis();
    }

    public String getDurationTimeStr() {
        Duration duration = Duration.between(startTime, endTime);
        long days = duration.toDays();
        long hours = duration.toHours();
        long minutes = duration.toMinutes();
        long millis = duration.toMillis();
        return days + "天：" + hours + " 小时：" + minutes + " 分钟：" + millis + " 毫秒：";
    }
}
