package org.matrix.actuators.usecase;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 当用户执行了一组测试用例后，会返回这个对象
 * @author huangxiahao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RunCaseResult extends BaseTime{

    private Long jobId;

    private String uniqueKey;

    /**
     * Key为caseId,List为case下的每一个执行结果
     */
    private List<TestCaseReport> caseReports= new ArrayList<>();

}
