package org.matrix.actuators.usecase;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 当用户执行了一组测试用例后，会返回这个对象
 * @author huangxiahao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TestCaseReport extends BaseTime{

    private Long caseId;

    private String caseName;

    private String type;

    private String detail;

    private String description;
    /**
     * 前置行动ID组，例如：1，2，3
     */
    private String moveBefore;

    /**
     * 后置行动ID组，例如：1，2，3
     */
    private String moveAfterCase;

    /**
     * 测试执行后行动ID组，例如：1，2，3
     */
    private String moveAfterTest;

    /**
     * 执行状态
     */
    private Boolean status;

    /**
     * case下的每一个执行结果
     */
    private List<TestDataExecuteResult> dataExecuteResults ;

    public TestCaseReport(LocalDateTime startTime, LocalDateTime endTime, Long caseId, String caseName, String type, String detail, String description, String moveBefore, String moveAfterCase, String moveAfterTest, Boolean status, List<TestDataExecuteResult> dataExecuteResults) {
        super(startTime, endTime);
        this.caseId = caseId;
        this.caseName = caseName;
        this.type = type;
        this.detail = detail;
        this.description = description;
        this.moveBefore = moveBefore;
        this.moveAfterCase = moveAfterCase;
        this.moveAfterTest = moveAfterTest;
        this.status = status;
        this.dataExecuteResults = dataExecuteResults;
    }
}
