package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.enums.FindType;

/**
 * @author mry
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("kt_test_job")
@ApiModel(value = "TestJob对象", description = "测试任务")
public class TestJob extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("sql语句")
    private String sqlStatement;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("保存方式,0,sql,1,保存")
    private FindType findType;
}
