package org.matrix.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * DynamicVarType.
 * 动态变量的数值类型
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/1/14 at 6:23 PM
 * Suffering is the most powerful teacher of life.
 */
@Getter
@AllArgsConstructor
public enum DynamicVarType {
    /**
     * 常量,即该变量的值不会发生变化
     */
    CONSTANT_VARIABLE(1, "常量"),
    /**
     * SQL变量,即该变量的值是经过SQL语句查询得到的
     */
    SQL_VARIABLE(2, "SQL变量"),
    /**
     * HTTP变量,即该变量的值是经过HTTP请求查询得到的
     */
    HTTP_VARIABLE(3, "HTTP变量"),
    /**
     * 测试用例变量,即该变量的值是经过测试用例查询得到的
     */
    CASE_VARIABLE(4, "测试用例变量");

    /**
     * 数据库里记录的字段使用该字段来记录
     */
    @EnumValue
    private final int code;

    private final String des;

}
