package org.matrix.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;

/**
 * ExecutionType.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/16 at 4:35 PM
 * Suffering is the most powerful teacher of life.
 */
@AllArgsConstructor
public enum ExecutionType {

    /**
     * 接口类的执行记录，2层数据结构
     */
    TEST_CASE(1,"接口类的执行记录，2层数据结构"),
    /**
     * "测试任务类的执行记录,3层数据结构"
     */
    TEST_JOB(2,"测试任务类的执行记录,3层数据结构");

    /**
     * 1,2
     */
    private final int code;

    /**
     * 描述
     */
    private final String des;

    @JsonValue
    public int getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }
}
