package org.matrix.testNg.web.report;

import org.matrix.testNg.web.TestNg;
import org.matrix.testNg.web.vo.DataBeansJobVo;
import org.matrix.testNg.web.vo.DataBeansVo;
import org.matrix.testNg.web.entity.ReportMessage;
import org.matrix.util.ReporterUtils;
import org.springframework.stereotype.Component;

/**
 * @author MRY
 */
@Component
public class TestNgImpl implements TestNg {

    /**
     * 单挑用例执行时,报告生成的位置
     *
     * @param dataBeansVo 报告中需要的信息
     * @return 报告位置信息
     */
    public ReportMessage getReportUrl(DataBeansVo dataBeansVo) {
        ReporterUtils.map.put("dataBeansVo", dataBeansVo);
        GenerateReporter generateReporter = new GenerateReporter();
        ReportMessage reportMessage = generateReporter.generateReport();
        return reportMessage;
    }

    /**
     * 多条用例执行时,报告生成的位置
     */
    public ReportMessage getReporterUrls(DataBeansJobVo dataBeansJobVo) {
        ReporterUtils.jobMap.put("job", dataBeansJobVo);
        GenerateReporterJob generateReporterJob = new GenerateReporterJob();
        ReportMessage reportMessage = generateReporterJob.generateReport();
        return reportMessage;
    }
}
