//a跟b进行比较,对象类型分为以下几种:基础类型、数组、普通对象
function equal(a, b) {
    var aType = Object.prototype.toString.call(a);
    var bType = Object.prototype.toString.call(b);
    switch (aType) {
        case "[object Array]":
            //数组类型
            switch (bType) {
                case "[object Array]":
                    return JSON.stringify(a) === JSON.stringify(b);
                default:
                    for (var i = 0; i < a.length; i++) {
                        if (JSON.stringify(a[i]) !== JSON.stringify(b)) {
                            return false;
                        }
                    }
                    return true;
            }
            break
        default:
            //基础类型和对象类型
            switch (bType) {
                case "[object Array]":
                    return equal(b, a);
                default:
                    return JSON.stringify(a) === JSON.stringify(b)
            }
    }
    return JSON.stringify(a) === JSON.stringify(b)
}


function contains(sourceValue, compareValue) {
    var sourceValueType = Object.prototype.toString.call(sourceValue);
    var compareValueType = Object.prototype.toString.call(compareValue);
    if (sourceValueType === "[object Object]") {
        for (var i = 0; i < Object.keys(sourceValue).length; i++) {
            var souceKey = Object.keys(sourceValue)[i];
            if (equal(sourceValue[souceKey], compareValue)) {
                return true;
            };
        }
        return false;
    } else if (sourceValueType == "[object Array]") {
        switch (compareValueType) {
            //如果数组包含的话，需要a种全包含b种的参数,例如： [1,2,3]比[1,2]为true ,  [1,2,3]比[1,2,3,4]为false
            case "[object Array]":
                //如果compareValue的长度 大于 sourceValue 则一定不包含
                if (sourceValue.length < compareValue.length) {
                    return false;
                }
                for (var i = 0; i < compareValue.length; i++) {
                    var innerFlag = false;
                    for (var j = 0; j < sourceValue.length; j++) {
                        if (JSON.stringify(compareValue[i]) == JSON.stringify(sourceValue[j])) {
                            innerFlag = true;
                            break;
                        }
                    }
                    if (!innerFlag) {
                        return false;
                    }
                }
                return true;
            case "[object Object]":
                for (var i = 0; i < sourceValue.length; i++) {
                    if (JSON.stringify(sourceValue[i]) == JSON.stringify(compareValue) ) {
                        return true;
                    }
                }
                return false;
            default:
                return sourceValue.indexOf(compareValue)> -1 ? true : false;
        }
        return false;
    } else {
        return JSON.stringify(sourceValue).indexOf(JSON.stringify(compareValue)) > -1 ? true : false
    }

}


function BaseEntity(value) {
    this.type = Object.prototype.toString.call(value);
    if (this.type != '[object Object]' && this.type != '[object Array]') {
        try {
            this.value = JSON.parse(value);
            this.type = Object.prototype.toString.call(this.value);
        } catch (error) {
            this.value = value;
        }
    } else {
        this.value = value;
    }
}

BaseEntity.prototype.get = function (key) {
    return this.value[key]
}

BaseEntity.prototype.length = function (key) {
    return this.value.length
}

BaseEntity.prototype.contains = function (key) {
    if(key instanceof BaseEntity){
        return contains(this.value,key.value)
    }else{
        return contains(this.value,key)
    }
}

BaseEntity.prototype.equal = function (key) {
    if(key instanceof BaseEntity){
        return equal(this.value,key.value)
    }else{
        return equal(this.value,key)
    }
}

var a = new BaseEntity('{"name":1,"age":2}');
var b = new BaseEntity('{"name":1,"age":3}');

