package org.matrix;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * Hello world!
 *
 * @author matrix
 */
@Slf4j
@EnableSwagger2
@EnableScheduling
@SpringBootApplication
@EntityScan(basePackages = {"org.matrix.remote.entity","org.matrix.local.entity"})
@MapperScan(basePackages = {"org.matrix.remote.mapper","org.matrix.local.mapper"})
public class ZentaoApplication {

    public static void main(String[] args) {
        SpringApplication.run(ZentaoApplication.class, args);
    }

}
