package org.matrix;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * Hello world!
 *
 * @author 27795
 */
@EnableSwagger2
@EnableCaching
@EnableScheduling
@SpringBootApplication
@MapperScan(basePackages = {"org.matrix.database.mapper", "org.matrix.zentao.mapper","org.matrix.remote.mapper","org.matrix.local.mapper"})
@ComponentScan(basePackages = {"org.matrix.local","org.matrix.remote","org.matrix"})
public class WebBootApplication {
    public static void main(String[] args) {
        SpringApplication.run(BaseBootApplication.class);
    }
}