package org.matrix.autotest.swaggerEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author MRY
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("接口信息")
public class PathInfoVo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("host")
    private String host;

    @ApiModelProperty("/")
    private String basePath;

    @ApiModelProperty("url地址")
    private String pathUrl;

    @ApiModelProperty("请求方式")
    private String httpMethod;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("方法名，总结")
    private String summary;

    @ApiModelProperty("类名，标签")
    private String tags;

    @ApiModelProperty("入参")
    private List<ParameterVo> reqList;

    @ApiModelProperty("返回值")
    private List<ResponseVo> respList;

}
