package org.matrix.autotest.utils;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.matrix.exception.GlobalException;

/**
 * @author MRY
 */
public class PageTools {

    public static void pageTool(int pageSize, int pageNum, Page<?> results) {
        int type = 0;
        //总共多少条数据
        long total = results.getTotal();
        //页数
        long length = total / pageSize;
        if (length == 0) {
            length = 1;
        }
        if (total % pageSize != 0) {
            length = length + 1;
        }
        if (pageNum > length) {
            throw new GlobalException(String
                    .format("%d 您查询的页码已经超出范围,允许查询的最大页码是 %d,您查询的页码是 %d",type, length, pageNum));
        }
    }
}
