package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.ProjectMapper;
import org.matrix.autotest.entity.Project;
import org.matrix.autotest.service.ProjectService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class ProjectServiceImpl extends ServiceImpl<ProjectMapper, Project> implements ProjectService {

    private final ProjectMapper projectMapper;

    public ProjectServiceImpl(ProjectMapper projectMapper) {
        this.projectMapper = projectMapper;
    }

    @Override
    public List<Project> findAllProject() {
        return projectMapper.selectList(null);
    }

    @Override
    public Project findByIdProject(Integer id) {
        return projectMapper.selectById(id);
    }

    @Override
    public int insertProject(Project project) {
        return projectMapper.insert(project);
    }

    @Override
    public int updateProject(Project project) {
        return projectMapper.updateById(project);
    }

    @Override
    public int deleteProject(Integer id) {
        return projectMapper.deleteById(id);
    }

}
