package org.matrix.database.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.matrix.actuators.sql.SqlExpDetail;
import org.matrix.enums.DynamicVarType;

/**
 * <p>
 *
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("dynamic_variable")
@ApiModel(value = "DynamicVariable对象", description = "")
public class DynamicVariable extends BaseEntity {

    @ApiModelProperty("所属项目")
    private Integer projectId;

    @ApiModelProperty("取用字段")
    private String takenField;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP")
    private DynamicVarType type;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("详细内容")
    private String detail;

    @ApiModelProperty(hidden = true)
    @TableField(exist = false)
    private SqlExpDetail sqlExpDetail;

    public DynamicVariable parseSqlDetail() {
        if (type == DynamicVarType.SQL_VARIABLE) {
            this.sqlExpDetail = JSON.parseObject(this.detail, SqlExpDetail.class);
        }
        return this;
    }


}
