package org.matrix.database.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.entity.DynamicVariable;
import org.matrix.database.vo.PageResult;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
public interface IDynamicVariableService extends IService<DynamicVariable> {

    /**
     * 根据变量名称获取变量
     *
     * @param name      变量名x
     * @param projectId 项目id
     * @return 变量
     */
    Optional<DynamicVariable> getByName(String name, Long projectId);

    /**
     * 添加动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 影响行数
     */
    int insertDynamicVariable(DynamicVariable dynamicVariable);

    /**
     * 修改动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 影响行数
     */
    int updateDynamicVariable(DynamicVariable dynamicVariable);

    /**
     * 删除动态变量
     *
     * @param id 动态变量
     * @return 影响行数
     */
    int deleteDynamicVariable(Integer id);

    /**
     * 根据项目id查询动作
     *
     * @param projectId 项目id
     * @return 符合项目id的动作
     */
    List<DynamicVariable> findByProjectIdDynamicVariable(Integer projectId);

    /**
     * 分页查询
     *
     * @param pageResult 封装的分页
     * @return 分页后的数据
     */
    PageResult pageAll(PageResult pageResult);

}
