package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.Environment;
import org.matrix.database.mapper.EnvironmentMapper;
import org.matrix.database.service.IEnvironmentService;
import org.matrix.database.vo.PageResult;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class EnvironmentServiceImpl extends ServiceImpl<EnvironmentMapper, Environment> implements IEnvironmentService {

    private final EnvironmentMapper environmentMapper;

    public EnvironmentServiceImpl(EnvironmentMapper environmentMapper) {
        this.environmentMapper = environmentMapper;
    }

    @Override
    public int insertEnvironment(Environment environment) {
        return environmentMapper.insert(environment);
    }

    @Override
    public int updateEnvironment(Environment environment) {
        return environmentMapper.updateById(environment);
    }

    @Override
    public int deleteEnvironment(Integer id) {
        return environmentMapper.deleteById(id);
    }

    @Override
    public List<Environment> findByProjectIdEnvironment(Integer projectId) {
        QueryWrapper<Environment> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        return environmentMapper.selectList(queryWrapper);
    }

    @Override
    public PageResult pageAll(PageResult pageResult) {
        IPage ipage = new Page(pageResult.getPageNum(), pageResult.getPageSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean flage = StringUtils.hasLength(pageResult.getQuery());
        queryWrapper.like(flage, "name", pageResult.getQuery());
        //执行分页查询，返回值依然是分页的对象
        ipage = environmentMapper.selectPage(ipage, queryWrapper);
        long total = ipage.getTotal();
        List<Environment> rows = ipage.getRecords();
        //回传5个参数 total/分页后的数据
        return pageResult.setTotal(total).setRows(rows);
    }

}
