/*
 Navicat Premium Data Transfer

 Source Server         : 我的阿里云
 Source Server Type    : MySQL
 Source Server Version : 80022
 Source Host           : 47.106.142.73:3306
 Source Schema         : lstest

 Target Server Type    : MySQL
 Target Server Version : 80022
 File Encoding         : 65001

 Date: 14/01/2022 11:22:30
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for action
-- ----------------------------
DROP TABLE IF EXISTS `action`;
CREATE TABLE `action`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `move_id` int NULL DEFAULT NULL COMMENT '行为ID',
  `project_id` int NULL DEFAULT NULL COMMENT '项目ID',
  `remark` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
  `type` int NULL DEFAULT NULL COMMENT '类型 1为SQL，2为HTTP，3为CASE，4为WAIT_TIME',
  `detail` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '详细参数',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_active_move`(`move_id`) USING BTREE,
  CONSTRAINT `fk_active_move` FOREIGN KEY (`move_id`) REFERENCES `move` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '动作' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for connect
-- ----------------------------
DROP TABLE IF EXISTS `connect`;
CREATE TABLE `connect`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'URL',
  `username` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '账号',
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '密码',
  `driver` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所用驱动',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for dynamic_variable
-- ----------------------------
DROP TABLE IF EXISTS `dynamic_variable`;
CREATE TABLE `dynamic_variable`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `project_id` int NULL DEFAULT NULL COMMENT '所属项目',
  `taken_field` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '取用字段',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `type` int NOT NULL COMMENT '动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP',
  `remark` varchar(510) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `detail` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '详细内容',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_project_dynamicVariable`(`project_id`) USING BTREE,
  CONSTRAINT `fk_project_dynamicVariable` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for example
-- ----------------------------
DROP TABLE IF EXISTS `example`;
CREATE TABLE `example`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '实例名称',
  `parameter_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '参数名 （例如：env）',
  `project_id` int NULL DEFAULT NULL COMMENT '项目ID',
  `variable` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '静态变量，以JSON的形式存储，例如（{\"name\":\"张三\"}）',
  `ip` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ip,例如（http:www.abc.com）',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_project_case`(`project_id`) USING BTREE,
  CONSTRAINT `fk_project_case` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '实例表，项目对应的环境实例，例如：实验室环境，开发环境等' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for move
-- ----------------------------
DROP TABLE IF EXISTS `move`;
CREATE TABLE `move`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `project_id` int NULL DEFAULT NULL COMMENT '所属项目',
  `remark` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_move_project`(`project_id`) USING BTREE,
  CONSTRAINT `fk_move_project` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for project
-- ----------------------------
DROP TABLE IF EXISTS `project`;
CREATE TABLE `project`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for test_case
-- ----------------------------
DROP TABLE IF EXISTS `test_case`;
CREATE TABLE `test_case`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `project_id` int NULL DEFAULT NULL COMMENT '所属项目',
  `type` int NOT NULL COMMENT '用例类型 1为http',
  `move_before` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '前置行动ID组，例如：1，2，3',
  `move_afer_case` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '后置行动ID组，例如：1，2，3',
  `move_afer_test` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '测试执行后行动ID组，例如：1，2，3',
  `abnormal_checkpoint` int NOT NULL DEFAULT 0 COMMENT '是否进行异常检验,0为否,1为是',
  `no_empty_checkpoint` int NOT NULL DEFAULT 0 COMMENT '是否进行非空检验,0为否,1为是',
  `contain_checkpoint` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四',
  `no_contain_checkpoint` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四',
  `database_checkpoint` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '数据库检验点，以JSON形式存放',
  `jsonpath_checkpoint` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'jsonpath检验点，以json形式存放',
  `detail` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '详细参数',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_case_project`(`project_id`) USING BTREE,
  CONSTRAINT `fk_case_project` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
