package org.matrix;

import lombok.extern.slf4j.Slf4j;
import org.matrix.actuators.datasource.DataSourceDTO;
import org.matrix.actuators.datasource.IDataSourceService;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * Hello world!
 *
 * @author matrix
 */
@Slf4j
@SpringBootApplication
@MapperScan("org.matrix.database.mapper")
public class BaseBootApplication implements CommandLineRunner {

    @Value("${spring.datasource.dynamic.datasource.master.url}")
    private String url;
    @Value("${spring.datasource.dynamic.datasource.master.username}")
    private String username;
    @Value("${spring.datasource.dynamic.datasource.master.password}")
    private String password;
    @Value("${spring.datasource.dynamic.datasource.master.driverClassName}")
    private String driverClassName;
    private final IDataSourceService dataSourceService;

    public BaseBootApplication(IDataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public static void main(String[] args) {
        SpringApplication.run(BaseBootApplication.class, args);
    }

    /**
     * Callback used to run the bean.
     *
     * @param args incoming main method arguments
     * @throws Exception on error
     */
    @Override
    public void run(String... args) throws Exception {
        log.info("[初始化] 初始化数据源" + driverClassName);
        dataSourceService.add(new DataSourceDTO("初始数据源",driverClassName,url,username,password));
    }
}
