package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.enums.ExecutionRecType;

/**
 * @author mry
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ExecutionRecord对象", description = "执行记录")
@TableName(autoResultMap = true, value = "kt_execution_record")
public class ExecutionRecord extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("测试任务id")
    private Long testTaskId;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("执行id")
    private Long performId;

    @ApiModelProperty("key用来记录执行批次")
    private String key;

    @ApiModelProperty("执行状态,0:关闭，1:开启")
    private ExecutionRecType status;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("日志")
    private String log;
}
