package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author mry
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("kt_test_task")
@ApiModel(value = "TestTask对象", description = "测试任务")
public class TestTask extends BaseEntity{

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("sql语句")
    private String sqlStatement;

    @ApiModelProperty("备注")
    private String remark;
}
