package org.matrix.socket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import org.junit.platform.commons.util.StringUtils;
import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.actuators.usecase.TestCaseExecuteResult;
import org.matrix.database.entity.TestCaseBTO;
import org.matrix.database.service.ITestDataService;
import org.matrix.exception.GlobalException;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

import java.util.List;

/**
 * webSocket处理
 * @author huangxiahao
 */
@Component
public class HttpAuthHandler  extends TextWebSocketHandler {

    final CaseActuator caseActuator;
    final ITestDataService testDataService;

    public HttpAuthHandler(CaseActuator caseActuator, ITestDataService testDataService) {
        this.caseActuator = caseActuator;
        this.testDataService = testDataService;
    }


    @Override
    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        session.sendMessage(new TextMessage("message get success"));
        String payload = message.getPayload();
        //检验客户端是否进行测试用例调试
        try {
            SocketVo socketVo = JSON.parseObject(payload, SocketVo.class);
            //如果客户端发送测试用例调试命令，则进行测试用例的执行
            if (socketVo!=null&& StringUtils.isNotBlank(socketVo.getType())){
                if (SocketType.TEST_CASE.toString().equals(socketVo.getType())){
                    //将websocketSession 加入到socket池子中
                    SocketPool.add(Thread.currentThread().getId(),session);
                    CaseExecuteVo caseExecuteVo = JSON.parseObject(payload, CaseExecuteVo.class);
                    List<Long> testDateIds = caseExecuteVo.getTestDateId();
                    for (Long testDateId : testDateIds) {
                        try {
                            TestCaseBTO testCaseBto = testDataService.toCaseBTO(testDateId);
                            //执行测试用例
                            TestCaseExecuteResult testCaseExecuteResult = caseActuator.executeTestCase(testCaseBto,1L,1L);
                            session.sendMessage(new TextMessage(JSON.toJSONString(testCaseExecuteResult)));
                        }catch (GlobalException e){
                            session.sendMessage(new TextMessage(e.getMessage()));
                        }
                    }
                    SocketPool.remove(Thread.currentThread().getId());
                }else {
                    session.sendMessage(new TextMessage("入参不符合规定"));
                }
            }
        }catch (JSONException e ){
            session.sendMessage(new TextMessage("入参不符合规定"));
        }

    }

}
