package org.matrix.socket;

import org.matrix.exception.GlobalException;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;


/**
 * 日志消息队列
 *
 * @author huangxiahao
 */
public class LogQueue {

    private static final ConcurrentHashMap<Long, List<String>> LOG_MAP = new ConcurrentHashMap<>();

    public static void add(Long threadId, String log) {
        List<String> logList = LOG_MAP.get(threadId);
        if (logList != null) {
            logList.add(log);
        } else {
            logList = new ArrayList<>();
            logList.add(log);
            LOG_MAP.put(threadId, logList);
        }
        //将log发送出去
        sendMessage(threadId, log);
    }

    public static void remove(Long threadId) {
        LOG_MAP.remove(threadId);
    }


        public static void sendMessage(Long threadId, String log) {
        try {
            WebSocketSession webSocketSession = SocketPool.get(threadId);
            if (webSocketSession != null) {
                webSocketSession.sendMessage(new TextMessage(log));
            }
        } catch (IOException e) {
            throw new GlobalException("发送socket消息失败,socket已经断开连接");
        }
    }

}
