package org.matrix.socket;

import org.springframework.web.socket.WebSocketSession;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @author huangxiahao
 */
public class SocketPool {

    private static final ConcurrentHashMap<Long, WebSocketSession> SOCKET_MAP = new ConcurrentHashMap<>();


    public static void add(Long key,WebSocketSession clientSocket){
        if (clientSocket != null &key !=null) {
            SOCKET_MAP.put(key, clientSocket);
        }
    }

    public static void remove(Long key){
        if (key!=null) {
            SOCKET_MAP.remove(key);
        }
    }

    public static WebSocketSession get(Long key){
       return SOCKET_MAP.get(key);
    }
}