package org.matrix.actuators.sql;

import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;

import org.matrix.actuators.httpclient.HttpClientActuator;
import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.actuators.usecase.TestCaseExecuteResult;
import org.matrix.database.entity.TestCase;
import org.matrix.database.entity.TestCaseBTO;
import org.matrix.database.entity.TestData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
class CaseActuatorTest {

    @Autowired
    CaseActuator caseActuator;

    @Test
    void test(){
        String json = "{\n" +
                "    \"url\":\"http://127.0.0.1:8080/test/sendMessage\",\n" +
                "    \"method\":\"GET\",\n" +
                "    \"requestType\":\"QUERY\",\n" +
                "    \"headers\":[\n" +
                "        {\n" +
                "            \"name\":\"cookie\",\n" +
                "            \"value\":\"123456\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"requestBodies\":[\n" +
                "        {\n" +
                "            \"key\":\"tableName\",\n" +
                "            \"type\":\"TEXT\",\n" +
                "            \"value\":\"张三\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        System.out.println(json);
        TestCase testCase = new TestCase();
        testCase.setName("name");
        testCase.setType(1);
        TestData testData = new TestData();
        testData.setDetail(json);
        testData.setAbnormalCheckpoint(1);
        testData.setContainCheckpoint("张三,李四");
        testData.setNoContainCheckpoint("张三,李四");
        testData.setJsonpathCheckpoint("contains({$..category},'${componentName}[0]')");
        TestCaseBTO testCaseBTO = new TestCaseBTO();
        testCaseBTO.setTestCase(testCase);
        testCaseBTO.setTestData(testData);
        TestCaseExecuteResult testCaseExecuteResult = caseActuator.executeTestCase(testCaseBTO,1L,1L);
        System.out.println(testCaseExecuteResult);


    }

}
