package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.enums.ExecutionRecType;
import org.matrix.socket.SocketType;
import org.matrix.socket.TestExecuteType;

/**
 * @author mry
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ExecutionRecord对象", description = "执行记录")
@TableName(autoResultMap = true, value = "kt_execution_record")
public class ExecutionRecord extends BaseEntity {

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("测试数据Id")
    private Long testDataId;

    @ApiModelProperty("任务id,如果不是从测试任务执行的记录不会有这个ID")
    private Long testJobId;

    @ApiModelProperty("用例id")
    private Long testCaseId;

    @ApiModelProperty("key用来记录执行批次")
    private String unionKey;

    @ApiModelProperty("执行状态,0:关闭，1:开启")
    private ExecutionRecType status = ExecutionRecType.RUN;

    @ApiModelProperty("类型")
    private TestExecuteType type;

    @ApiModelProperty("日志")
    private String log;
}
