package org.matrix.database.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.ExecutionRecord;
import org.matrix.database.mapper.ExecutionRecordMapper;
import org.matrix.database.service.IExecutionRecordService;
import org.matrix.enums.ExecutionRecType;
import org.matrix.exception.GlobalException;
import org.matrix.socket.TestExecuteLog;
import org.matrix.socket.TestExecuteType;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author mry
 */
@Service
public class ExecutionRecordImpl extends ServiceImpl<ExecutionRecordMapper, ExecutionRecord> implements IExecutionRecordService {

    @Override
    public void addExecutionRecord(TestExecuteLog testExecuteLog,String log) {
        ExecutionRecord executionRecord = new ExecutionRecord();
        BeanUtils.copyProperties(testExecuteLog,executionRecord);
        executionRecord.setLog(log);
        this.save(executionRecord);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void setStatusByUnionKey(String unionKey, ExecutionRecType status) {
        boolean emptyIfStr = StrUtil.isEmptyIfStr(unionKey);
        if (emptyIfStr){
            throw new GlobalException("不能根据空的unionKey修改执行状态");
        }else {
            ExecutionRecord executionRecord = new ExecutionRecord();
            executionRecord.setStatus(status);
            update(executionRecord,Wrappers
                    .lambdaUpdate(ExecutionRecord.class)
                    .eq(ExecutionRecord::getUnionKey,unionKey)
            );
        }
    }




}
