package org.matrix.local.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * MetaFieldHandler.
 * 元数据处理器，用于处理自动填充的字段
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 7:52 下午
 */
@Component
public class MetaFieldHandler implements MetaObjectHandler {
    /**
     * 创建时设置创建时间
     * @param metaObject 数据库原始对象
     */
    @Override
    public void insertFill(MetaObject metaObject) {
        this.strictInsertFill(metaObject, "createTime", LocalDateTime.class, LocalDateTime.now());
        this.strictInsertFill(metaObject, "updateTime", LocalDateTime.class, LocalDateTime.now());
    }

    /**
     * 更新时设置更新时间
     * @param metaObject 数据库原始对象
     */
    @Override
    public void updateFill(MetaObject metaObject) {
        this.strictUpdateFill(metaObject, "updateTime", LocalDateTime.class, LocalDateTime.now());
    }
}
