package org.matrix.actuators.checkpoint;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 检测结果
 * @author Administrator
 */
@Data
public class CheckPointResult {

    private List<CheckPointResultDetail> checkPointResultDetails = new ArrayList<>();

    public Long getSuccessNum() {
        return checkPointResultDetails.stream().filter(CheckPointResultDetail::getIsSuccess).count();
    }

    public Long getFailNum() {
        return checkPointResultDetails.size() - getSuccessNum();
    }

    public Boolean addCheckPointResultDetail(CheckPointResultDetail checkPointResultDetail){
        return checkPointResultDetails.add(checkPointResultDetail);
    }
}
