package org.matrix.actuators.datasource;

import java.util.Set;

/**
 * IDataSourceService.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/1/19 at 5:38 PM
 * Suffering is the most powerful teacher of life.
 */
public interface IDataSourceService {


    /**
     * 将当前使用的数据替换为参数提供的数据源,如果还没有,则会添加,如果已经有了,则不会添加
     *
     * @param dto 数据源信息
     * @return 当前已经存在的数据源集合
     */
    @SuppressWarnings("UnusedReturnValue")
    Set<String> switchDataSource(DataSourceDTO dto);

    /**
     * 添加数据源,如果已经存在同名的数据源了,则不会添加
     *
     * @param dto 数据源信息
     * @return 数据源名称的集合, 用于 DynamicDataSourceContextHolder.push("数据源名称") 这样的代码中
     */
    Set<String> add(DataSourceDTO dto);

    /**
     * 添加数据源,如果已经存在同名的数据源了,则会覆盖
     *
     * @param dto 数据源信息
     * @return 数据源名称的集合, 用于 DynamicDataSourceContextHolder.push("数据源名称") 这样的代码中
     */
    Set<String> addAndUpdate(DataSourceDTO dto);

    /**
     * 获取当前所有数据源
     *
     * @return 数据源名称的集合, 用于 DynamicDataSourceContextHolder.push("数据源名称") 这样的代码中
     */
    Set<String> now();

    /**
     * 删除数据源
     *
     * @param name 数据源名称
     * @return 删除信息
     */
    public String remove(String name);


}
