package org.matrix.testNg;

import org.testng.ITestResult;
import org.testng.annotations.*;

import java.util.Iterator;
import java.util.Map;

/**
 * @author mry
 */
public class TestPigeon {

    String sql;
    Integer envId;

    @Parameters({"sql", "envId"})
    @BeforeClass
    public void beforeClass(String sql, Integer envId) {
        this.sql = sql;
        this.envId = envId;
    }

    /**
     * XML中的SQL决定了执行什么用例, 执行多少条用例, SQL的搜索结果为需要测试的测试用例
     */
    @DataProvider(name = "testData")
    private Iterator<Object[]> getData() {
        return new DataProviderForDb(TestConfig.DB_IP, TestConfig.DB_PORT,
                TestConfig.DB_BASE_NAME, TestConfig.DB_USERNAME, TestConfig.DB_PASSWORD, sql);
    }

    @Test(dataProvider = "testData")
    public void test(Map<String, String> data) {

    }

    @AfterMethod
    public void afterMethod(ITestResult result, Object[] objs) {
        System.out.println("正在运行的方法:" + result.getName());
    }

}
