package org.matrix.actuators.sql;

import com.alibaba.fastjson.JSON;
import org.junit.runner.RunWith;
import org.matrix.actuators.httpclient.HttpClientActuator;
import org.matrix.actuators.httpclient.HttpRequestDetail;
import org.matrix.config.HttpRequestConfig;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
public class HttpClientActuatorTest {

    public void test(){
        HttpClientActuator httpClientActuator = new HttpClientActuator(
                new HttpRequestConfig(),
                0l,
                0l
        );
        String json = "{\n" +
                "    \"url\":\"http://127.0.0.1:13245/test/sayHelloJson\",\n" +
                "    \"method\":\"POST\",\n" +
                "    \"requestType\":\"JSON\",\n" +
                "    \"stringValue\":\"{\\\"name\\\":\\\"李四\\\"}\",\n" +
                "    \"headers\":[\n" +
                "        {\n" +
                "            \"name\":\"cookie\",\n" +
                "            \"value\":\"123456\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        HttpRequestDetail httpRequestDetail = JSON.parseObject(json, HttpRequestDetail.class);
        httpClientActuator.sendHttpRequest(httpRequestDetail);
    }

}
