package org.matrix.actuators.usecase;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.actuators.checkpoint.CheckPointResult;

import java.time.LocalDateTime;

/**
 * @author huangxiahao
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TestDataExecuteResult extends BaseTime{

    private Boolean executionStatus ;

    private Long caseId;

    private Long dataId;

    private BaseTestCaseResponseDetail baseTestCaseResponseDetail;

    private CheckPointResult checkPointResult;


    public TestDataExecuteResult(LocalDateTime startTime, LocalDateTime endTime, Boolean executionStatus, Long caseId, Long dataId, BaseTestCaseResponseDetail baseTestCaseResponseDetail, CheckPointResult checkPointResult) {
        super(startTime, endTime);
        this.executionStatus = executionStatus;
        this.caseId = caseId;
        this.dataId = dataId;
        this.baseTestCaseResponseDetail = baseTestCaseResponseDetail;
        this.checkPointResult = checkPointResult;
    }
}
