package org.matrix.database.controller;

import com.alibaba.fastjson.JSONObject;
import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.actuators.usecase.TestDataExecuteResult;
import org.matrix.database.entity.ExecutionRecord;
import org.matrix.database.entity.TestCase;
import org.matrix.database.entity.TestCaseBTO;
import org.matrix.database.entity.TestData;
import org.matrix.database.service.IExecutionHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.groupingBy;

/**
 * TestController. 用于测试的控制器
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/1/21 at 4:53 PM
 * Suffering is the most powerful teacher of life.
 */
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    CaseActuator caseActuator;

    @Autowired
    IExecutionHistoryService executionHistoryService;

    public String treeTest() {
        List<ExecutionRecord> recordList = new ArrayList<>();
        Map<Long, Map<Long, Map<Long, List<ExecutionRecord>>>> map = recordList.stream().collect(
                groupingBy(ExecutionRecord::getTestJobId,
                        groupingBy(ExecutionRecord::getTestCaseId,
                                groupingBy(ExecutionRecord::getTestDataId))));
        return "";
    }

    /**
     * 获得表名,用于测试http执行器的调用
     */
    @GetMapping("/tableName")
    public ResponseEntity<String> getTableName(@RequestParam String tableName) {
        return ResponseEntity.ok(tableName);
    }

    @PostMapping("/sayHelloJson")
    public String sendMessage(@RequestBody Hello hello) {
        return String.format("{\n" +
                "    \"store\": {\n" +
                "        \"book\": [\n" +
                "            {\n" +
                "                \"category\": \"%s\",\n" +
                "                \"author\": \"Nigel Rees\",\n" +
                "                \"title\": \"Sayings of the Century\",\n" +
                "                \"price\": 8.95\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"Evelyn Waugh\",\n" +
                "                \"title\": \"Sword of Honour\",\n" +
                "                \"price\": 12.99\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"Herman Melville\",\n" +
                "                \"title\": \"Moby Dick\",\n" +
                "                \"isbn\": \"0-553-21311-3\",\n" +
                "                \"price\": 8.99\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"J. R. R. Tolkien\",\n" +
                "                \"title\": \"The Lord of the Rings\",\n" +
                "                \"isbn\": \"0-395-19395-8\",\n" +
                "                \"price\": 22.99\n" +
                "            }\n" +
                "        ],\n" +
                "        \"bicycle\": {\n" +
                "            \"color\": \"red\",\n" +
                "            \"price\": 19.95\n" +
                "        }\n" +
                "    },\n" +
                "    \"expensive\": 10\n" +
                "}", hello.getName());
    }

    @GetMapping("/sendMessage")
    public ResponseEntity sendMessage(String tableName) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", String.format("你好: %s", tableName));
        return ResponseEntity.ok(jsonObject);
    }

    @GetMapping("/testCase")
    public void testCase() {
        String json = "{\n" +
                "    \"url\":\"http://127.0.0.1:8080/test/sendMessage\",\n" +
                "    \"method\":\"GET\",\n" +
                "    \"requestType\":\"QUERY\",\n" +
                "    \"headers\":[\n" +
                "        {\n" +
                "            \"name\":\"cookie\",\n" +
                "            \"value\":\"123456\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"requestBodies\":[\n" +
                "        {\n" +
                "            \"key\":\"tableName\",\n" +
                "            \"type\":\"TEXT\",\n" +
                "            \"value\":\"张三\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        System.out.println(json);
        TestCase testCase = new TestCase();
        testCase.setName("name");
        testCase.setType(1);
        TestData testData = new TestData();
        testData.setDetail(json);
        testData.setAbnormalCheckpoint(1);
        testData.setContainCheckpoint("张三,李四");
        testData.setNoContainCheckpoint("张三,李四");
        testData.setJsonpathCheckpoint("contains({$..category},'${componentName}[0]')");
        TestCaseBTO testCaseBTO = new TestCaseBTO();
        testCaseBTO.setTestCase(testCase);
        testCaseBTO.setTestData(testData);
        TestDataExecuteResult testDataExecuteResult = caseActuator.executeTestCase(testCaseBTO, 1L, 1L);
        System.out.println(testDataExecuteResult);
    }
}
