package org.matrix.generator;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.TemplateType;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

import java.util.Collections;

/**
 * CodeGenerator.
 * 代码生成器
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/1/15 at 3:56 PM
 * Suffering is the most powerful teacher of life.
 */
public class CodeGenerator {

    private static final String URL = "jdbc:mysql://localhost:3306/test?useUnicode=true&characterEncoding=utf-8&useSSL=false";

    private static final String USERNAME = "root";

    private static final String PASSWORD = "ldf3291369";

    public static void main(String[] args) {
        String modelPath = "/kt-base";
        String pkgPath = System.getProperty("user.dir") + modelPath + "/src/main/java/";
        String resPath = System.getProperty("user.dir") + modelPath + "/src/main/resource/";
        FastAutoGenerator.create(URL, USERNAME, PASSWORD)
                .globalConfig(builder -> {
                    builder.author("matrix") // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .fileOverride() // 覆盖已生成文件
                            .disableOpenDir()// 关闭文件打开功能
                            .outputDir(pkgPath); // 指定输出目录
                })
                .packageConfig(builder -> {
                    builder.parent("org.matrix") // 设置父包名
                            .moduleName("database")
                            .pathInfo(Collections.singletonMap(OutputFile.mapperXml, resPath)); // 设置mapperXml生成路径
                })
                .strategyConfig(builder -> {
                    builder.entityBuilder()
                            .enableLombok()
                            .disableSerialVersionUID() // 禁用序列化
                            .superClass("org.matrix.database.entity.BaseEntity") // 自定义实体父类
                            .addIgnoreColumns("create_time", "update_time", "id"); // 忽略生成的字段
                })
                .templateConfig(builder -> {
                    builder.disable(TemplateType.CONTROLLER, TemplateType.ENTITY, TemplateType.MAPPER) // 禁用模板
                            .entity("template/entity.java") // 设置实体模板
                            .mapper("template/mapper.java"); // 设置mapper模板
                })
                // 使用Freemarker引擎模板
                .templateEngine(new FreemarkerTemplateEngine())
                .execute();
    }
}
