create table kt_action
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    name        varchar(255) null,
    move_id     bigint(11)   null comment '行为ID',
    project_id  bigint(11)   null comment '项目ID',
    remark      text         null comment '备注',
    type        int          null comment '类型 1为SQL，2为HTTP，3为CASE，4为WAIT_TIME',
    env_id      bigint(11)   null comment '环境id',
    detail      text         null comment '详细参数',
    create_time timestamp    not null comment '数据创建时间',
    update_time timestamp    not null comment '数据更新时间'
)
    comment
        '动作表,包含了实际的动作参数' charset = utf8;

create index fk_active_move
    on kt_action (move_id);

create table kt_connect
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    name        varchar(255) null comment '名称',
    url         varchar(255) null comment 'URL',
    username    varchar(255) null comment '账号',
    password    varchar(255) null comment '密码',
    driver      varchar(255) null comment '所用驱动',
    create_time timestamp    not null comment '数据创建时间',
    update_time timestamp    not null comment '数据更新时间'
)
    comment
        '连接表,包含里连接数据源所需要的参数' charset = utf8;

create table kt_dynamic_variable
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    project_id  bigint(11)   null comment '所属项目',
    taken_field varchar(255) null comment '取用字段',
    name        varchar(255) null comment '名称',
    type        int          not null comment '动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP',
    remark      varchar(510) null comment '备注',
    detail      text         null comment '详细内容',
    create_time timestamp    not null comment '数据创建时间',
    update_time timestamp    not null comment '数据更新时间'
)
    comment
        '动态变量表,用于表示数值会发生变化的变量' charset = utf8;

create index fk_project_dynamicVariable
    on kt_dynamic_variable (project_id);

create table kt_environment
(
    id             bigint(11) auto_increment comment 'ID'
        primary key,
    name           varchar(255) null comment '实例名称',
    parameter_name varchar(255) null comment '参数名 （例如：env）',
    project_id     bigint(11)   null comment '项目ID',
    variable       text         null comment '静态变量，以JSON的形式存储，例如（{"name":"张三"}）',
    is_default     tinyint(255) null comment '是否为默认',
    ip             varchar(255) null comment 'ip,例如（http:www.abc.com）',
    create_time    timestamp    not null comment '数据创建时间',
    update_time    timestamp    not null comment '数据更新时间'
)
    comment
        '实例表，项目对应的环境实例，例如：实验室环境，开发环境等' charset = utf8;

create index fk_project_case
    on kt_environment (project_id);

create table kt_execution_record
(
    id           bigint(11) auto_increment comment 'ID'
        primary key,
    user_id      bigint(11)                null comment '用户id',
    test_job_id  bigint                    null comment '测试任务id',
    test_case_id bigint                    null comment '测试用例id',
    test_data_id bigint                    null comment '测试数据id',
    status       int                       null comment '执行状态,0:停止，1:执行',
    type         varchar(255) charset utf8 null comment '类型',
    unique_key    varchar(255) charset utf8 null comment 'key用来记录执行批次',
    log          text charset utf8         null comment '日志',
    create_time  timestamp                 not null comment '数据创建时间',
    update_time  timestamp                 not null comment '数据更新时间'
)
    comment
        '执行记录表,记录用例执行过程中的日志' charset = utf8;

create table kt_move
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    name        varchar(255) null comment '名称',
    project_id  bigint(11)   null comment '所属项目',
    remark      text         null comment '备注',
    create_time timestamp    not null comment '数据创建时间',
    update_time timestamp    not null comment '数据更新时间'
) comment '行为表,作为动作表的父级,根据环境来决定行为实例的动作是什么' charset = utf8;

create index fk_move_project
    on kt_move (project_id);

create table kt_project
(
    id          bigint(11)   not null comment 'ID'
        primary key,
    name        varchar(255) null comment '名称',
    project_url varchar(255) null comment '/v2/api-docs地址',
    create_time timestamp    not null comment '数据创建时间',
    update_time timestamp    not null comment '数据更新时间'
)
    comment
        '项目表,数据由读取禅道获得' charset = utf8;

create table kt_test_case
(
    id              bigint(11) auto_increment comment 'ID'
        primary key,
    name            varchar(255) null comment '名称',
    project_id      bigint(11)   null comment '所属项目',
    type            int          not null comment '用例类型 1为http',
    detail          text         null comment '详细参数',
    move_before     varchar(255) null comment '前置行动ID组，例如：1，2，3',
    move_after_case varchar(255) null comment '后置行动ID组，例如：1，2，3',
    move_after_test varchar(255) null comment '测试执行后行动ID组，例如：1，2，3',
    des             varchar(255) null comment '用例描述',
    create_time     timestamp    not null comment '数据创建时间',
    update_time     timestamp    not null comment '数据更新时间'
)
    comment
        '测试用例表，测试的平台的主体数据' charset = utf8;

create index fk_case_project
    on kt_test_case (project_id);

create table kt_test_data
(
    id                    bigint auto_increment comment '主键id'
        primary key,
    name                  varchar(255) charset utf8 null comment '名称',
    abnormal_checkpoint   int                       not null comment '是否进行异常检验,0为否,1为是',
    no_empty_checkpoint   int                       not null comment '是否进行非空检验,0为否,1为是',
    contain_checkpoint    text charset utf8         null comment '包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四',
    no_contain_checkpoint text charset utf8         null comment '不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四',
    database_checkpoint   text charset utf8         null comment '数据库检验点，以JSON形式存放',
    jsonpath_checkpoint   text charset utf8         null comment 'jsonpath检验点，以json形式存放',
    detail                text charset utf8         null comment '详细参数',
    test_case_id          bigint                    not null comment '关联的测试用例的id',
    create_time           timestamp                 not null comment '数据创建时间',
    update_time           timestamp                 not null comment '数据更新时间'
)
    comment
        '测试接口的一组数据' charset = utf8;

create table kt_test_task
(
    id            bigint(11) auto_increment comment 'ID'
        primary key,
    name          varchar(255) charset utf8 null comment '名称',
    sql_statement text charset utf8         null comment 'sql语句',
    remark        varchar(510) charset utf8 null comment '备注',
    create_time   timestamp                 not null comment '数据创建时间',
    update_time   timestamp                 not null comment '数据更新时间'
)
    comment
        '测试任务表,用于选取某一组要测试的测试用例' charset = utf8;

create table kt_user
(
    id          bigint(11)   not null
        primary key,
    create_time timestamp    not null comment '数据创建时间',
    update_time timestamp    not null comment '数据更新时间',
    name        varchar(255) null,
    account     varchar(255) null,
    password    varchar(255) null
)
    comment
        '用户表,数据由读取禅道获得' charset = utf8;

create table kt_user_project
(
    id         bigint(11) auto_increment
        primary key,
    user_id    bigint(11) null,
    project_id bigint(11) null
)
    comment
        '用户表与数据表的中间表,用来记录多对多的记录关系' charset = utf8;

