<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="./res/css/index.css">
    <link rel="stylesheet" href="./res/css/reset.css">
    <link rel="stylesheet" href="./res/css/bootstrap.css">
</head>

<body>
<div class="top">
    测试报告
</div>
<div class="content">
    <div class="topForm">
        <div class="topTitle">报告汇总</div>
        <form class="form">
            <#if overView ??>
                <div class="form-group flex">
                    <label for="total">测试用例总数:</label>
                    <input class="form-control" id="total" readonly="readonly" value="${overView.total!}"/>
                </div>
                <div class="form-group flex">
                    <label for="allTime">执行总耗时:</label>
                    <input class="form-control" id="allTime" readonly="readonly" value="${overView.allTime!}"/>
                </div>
                <div class="form-group flex">
                    <label for="passNum">通过用例数:</label>
                    <input class="form-control" id="passNum" readonly="readonly" value="${overView.passNum!}"/>
                </div>
                <div class="form-group flex">
                    <label for="failNum">失败用例数:</label>
                    <input class="form-control" id="failNum" readonly="readonly" value="${overView.failNum!}"/>
                </div>
                <div class="form-group flex">
                    <label for="probability">测试通过率:</label>
                    <input class="form-control" id="probability" readonly="readonly" value="${overView.probability!}"/>
                </div>
            <#else>
            </#if>
        </form>
    </div>
    <div class="table">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>编号</th>
                <th>用例名称</th>
                <th>用例类型</th>
                <th>详细参数</th>
                <th>用例描述</th>
                <th>执行结果</th>
                <th>执行时间</th>
                <th>结果信息</th>
            </tr>
            </thead>
            <tbody>
            <#assign caseNo = 0>
            <#if fail ??>
                <#list fail as failCase>
                    <tr>
                        <#assign caseNo=caseNo+1>
                        <th scope="row">${caseNo}</th>
                        <td>${failCase.testCaseName!}</td>
                        <td>${failCase.type!}</td>
                        <td>${failCase.detail!}</td>
                        <td>${failCase.description!}</td>
                        <td style="color: red">${failCase.result?c}</td>
                        <td>${failCase.duration!}</td>
                        <td class="clickClass" data-message="${failCase.resultMessage!}">查看结果</td>
                    </tr>
                </#list>
            <#else>
            </#if>
            </tbody>
            <tbody>
            <#assign caseNo = 0>
            <#if pass ??>
                <#list pass as passCase>
                    <tr>
                        <#assign caseNo=caseNo+1>
                        <th scope="row">${caseNo}</th>
                        <td>${passCase.testCaseName!}</td>
                        <td>${passCase.type!}</td>
                        <td>${passCase.detail!}</td>
                        <td>${passCase.description!}</td>
                        <td style="color: green">${passCase.result?c}</td>
                        <td>${passCase.duration!}</td>
                        <td class="clickClass" data-message="${passCase.resultMessage!}">查看结果</td>
                    </tr>
                </#list>
            <#else>
            </#if>
            </tbody>
        </table>
    </div>
</div>
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">结果信息</h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" id="grp">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">关闭</button>
            </div>
        </div>
    </div>
</div>
<script src="./res/js/jquery.min.js"></script>
<script src="./res/js/bootstrap.js"></script>
<script>
    function handleData(data) {
        let a = data
        let b = a.split('=').splice(1, a.split('=').length - 2)
        let c = b.join('=').split('(')[1].split(')')[0]
        let d = c.split(',')
        let e = []
        d.map(v => {
            e.push({key: v.split('=')[0] + ":", value: v.split('=')[1]})
        })
        return e
    }

    $(".clickClass").each((i, v) => {
        v.onclick = function () {
            if (!v.getAttribute('data-message')) {
                alert('该条测试数据执行失败')
                return
            }
            let data = handleData(v.getAttribute('data-message'))
            $('#myModal').modal()
            if (data) {
                let oDiv = document.getElementById('grp')
                $("#grp").empty();
                data.map(v => {
                    let div1 = document.createElement('div')
                    let lab1 = document.createElement('label')
                    let lab2 = document.createElement('label')
                    div1.className = 'form-group'
                    lab1.className = 'col-sm-4 control-label w20'
                    lab2.className = 'col-sm-6 control-label txtl'
                    lab1.innerText = v.key
                    lab2.innerText = v.value
                    div1.appendChild(lab1)
                    div1.appendChild(lab2)
                    oDiv.appendChild(div1)
                })
            }
        }
    })
</script>
</body>
</html>