package org.matrix.database.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.entity.ExecutionHistory;
import org.matrix.database.vo.ExecutionHistoryVo;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-03-11
 */
public interface IExecutionHistoryService extends IService<ExecutionHistory> {

    /**
     * 根据CaseId和JobId 查询对应的数据列表
     * @param pageNum 页码
     * @param pageSize 分页条数
     * @param jobId 测试任务ID
     * @param caseId 用例ID
     * @return 执行记录列表
     */
    IPage<ExecutionHistoryVo> pageExecutionHistoryVoByCaseIdAndJobId(Long caseId, Long jobId, int pageSize, int pageNum);

    /**
     * 根据CaseId和JobId 查询对应的最后一次执行记录
     * @param jobId 测试任务ID
     * @param caseId 用例ID
     * @return 执行记录
     */
    ExecutionHistoryVo getLastExecutionHistory(Long caseId, Long jobId);


}
