package org.matrix.database.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.entity.TestCaseBTO;
import org.matrix.database.entity.TestData;

/**
 * ITestDataService.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/2/22 at 3:05 PM
 * Suffering is the most powerful teacher of life.
 */
@SuppressWarnings("AlibabaLowerCamelCaseVariableNaming")
public interface ITestDataService extends IService<TestData> {

    /**
     * 根据testData主键id 转换出TestCaseBTO对象,多用于动态参数绑定中
     * @param testDataId testData的主键id
     * @return {@link TestCaseBTO} 特指某个单条数据的测试用例，多用于动态参数绑定中
     */
    TestCaseBTO toCaseBTO(Long testDataId);

    /**
     * {{@link #toCaseBTO(Long)}} 的重载方法
     */
    TestCaseBTO toCaseBTO(TestData testData);
}
