package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.BaseEntity;
import org.matrix.database.entity.ExecutionHistory;
import org.matrix.database.mapper.ExecutionHistoryMapper;
import org.matrix.database.service.IExecutionHistoryService;
import org.matrix.database.vo.ExecutionHistoryVo;
import org.matrix.enums.ExecutionHistoryStatus;
import org.matrix.exception.GlobalException;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import static java.util.Comparator.comparingLong;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-03-11
 */
@Service
public class ExecutionHistoryServiceImpl extends ServiceImpl<ExecutionHistoryMapper, ExecutionHistory> implements IExecutionHistoryService {

    @Override
    public IPage<ExecutionHistoryVo> pageExecutionHistoryVoByCaseIdAndJobId(Long caseId, Long jobId, int pageNum, int pageSize ) {
        // todo 黄夏豪 等待接入用户ID
        Page<ExecutionHistoryVo> page = new Page<>(pageNum, pageSize);
        return baseMapper.pageByCaseIdAndJobId(page,caseId,jobId,1L);
    }

    @Override
    public ExecutionHistoryVo getLastExecutionHistory(Long caseId, Long jobId) {
        return baseMapper.selectLastExecutionHistoryVo(caseId,jobId,1L);
    }


}
