package org.matrix.actuators.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;

import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.actuators.usecase.TestCaseExecuteResult;
import org.matrix.database.entity.TestCase;
import org.matrix.database.entity.TestCaseBTO;
import org.matrix.database.entity.TestData;
import org.matrix.database.service.IExecutionRecordService;
import org.matrix.database.service.ITestCaseService;
import org.matrix.database.service.ITestDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
class CaseActuatorTest {

    @Autowired
    CaseActuator caseActuator;

    @Autowired
    IExecutionRecordService executionRecordService;

    @Autowired
    ITestCaseService iTestCaseService;

    @Autowired
    ITestDataService iTestDataService;

    @Test
    void testList(){
        // 测试任务ID.测试用例ID.测试数据ID.日志
//        String str1 = "-1.2.2.张三";
//        String str2 = "-1.2.2.李四";
//        String str3 = "-1.2.3.张三";
//        String str4 = "-1.2.3.张三";
//        List<ExecutionRecord> records = new ArrayList<>();

         TestCase byId = iTestCaseService.getById(3);
        System.out.println(JSONObject.toJSON(byId));
         TestData byId1 = iTestDataService.getById(3);
        System.out.println(JSONObject.toJSON(byId1));


//        String str1 = "2.张三";
//        String str2 = "2.李四";
//        String str3 = "3.张三";
//        String str4 = "3.张三";
//        JSONObject object = new JSONObject();
//        JSONArray jsonArray = new JSONArray();

    }

    void t(JSON json, String str){
        JSON newJson ;
        //判断str中有没有.  如果没有点则证明为最后一个参数，由于最后一个参数的实际类型为jsonArray并且为递归退出条件所以需要特殊处理
        if (str.contains(".")){
            //切割获取点前面的字符

        }else {

        }
    }



    @Test
    void test(){
        String json = "{\n" +
                "    \"url\":\"http://127.0.0.1:8080/test/sendMessage\",\n" +
                "    \"method\":\"GET\",\n" +
                "    \"requestType\":\"QUERY\",\n" +
                "    \"headers\":[\n" +
                "        {\n" +
                "            \"name\":\"cookie\",\n" +
                "            \"value\":\"123456\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"requestBodies\":[\n" +
                "        {\n" +
                "            \"key\":\"tableName\",\n" +
                "            \"type\":\"TEXT\",\n" +
                "            \"value\":\"张三\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        System.out.println(json);
        TestCase testCase = new TestCase();
        testCase.setName("name");
        testCase.setType(1);
        TestData testData = new TestData();
        testData.setDetail(json);
        testData.setAbnormalCheckpoint(1);
        testData.setContainCheckpoint("张三,李四");
        testData.setNoContainCheckpoint("张三,李四");
        testData.setJsonpathCheckpoint("contains({$..category},'${componentName}[0]')");
        TestCaseBTO testCaseBTO = new TestCaseBTO();
        testCaseBTO.setTestCase(testCase);
        testCaseBTO.setTestData(testData);
        TestCaseExecuteResult testCaseExecuteResult = caseActuator.executeTestCase(testCaseBTO,1L,1L);
        System.out.println(testCaseExecuteResult);


    }

}
