package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * <p>
 * 
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("test_case")
@ApiModel(value = "TestCase对象", description = "")
public class TestCase extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("所属项目")
    private Integer projectId;

    @ApiModelProperty("用例类型 1为http")
    private Integer type;

    @ApiModelProperty("前置行动ID组，例如：1，2，3")
    private String moveBefore;

    @ApiModelProperty("后置行动ID组，例如：1，2，3")
    private String moveAferCase;

    @ApiModelProperty("测试执行后行动ID组，例如：1，2，3")
    private String moveAferTest;

    @ApiModelProperty("是否进行异常检验,0为否,1为是")
    private Integer abnormalCheckpoint;

    @ApiModelProperty("是否进行非空检验,0为否,1为是")
    private Integer noEmptyCheckpoint;

    @ApiModelProperty("包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四")
    private String containCheckpoint;

    @ApiModelProperty("不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四")
    private String noContainCheckpoint;

    @ApiModelProperty("数据库检验点，以JSON形式存放")
    private String databaseCheckpoint;

    @ApiModelProperty("jsonpath检验点，以json形式存放")
    private String jsonpathCheckpoint;

    @ApiModelProperty("详细参数")
    private String detail;

}
