package org.matrix.entity.httpRequest;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.springframework.http.HttpMethod;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Data
public class HttpRequestDetail {


    @ApiModelProperty("请求头")
    private List<RequestHeader> headers = new ArrayList<>();

    @ApiModelProperty("URL")
    private String url = new String();

//    @ApiModelProperty("请求类型")
    private HttpRequestType requestType = HttpRequestType.NONE;

    @ApiModelProperty("请求方法")
    private HttpMethod method;

    @ApiModelProperty("字符串入参")
    private String stringValue = new String();

    @ApiModelProperty("键值对入参")
    private List<RequestBody> requestBodies = new ArrayList<>();

    /**
     * 增加键值对入参
     * @param requestBody
     * @return
     */
    private Boolean addRequestBody(RequestBody requestBody) {
        return requestBodies.add(requestBody);
    }

    /**
     * 增加请求头
     * @param name
     * @param value
     * @return
     */
    public Boolean addHeaders(String name, String value) {
        return headers.add(new RequestHeader(name, value));
    }

    /**
     * 以数组的形式获取请求头
     * @return
     */
    public Header[] getHeadersArray() {
        List<BasicHeader> collect =
                headers.stream().map(RequestHeader::getBasicHeader).collect(Collectors.toList());
        return collect.toArray(new Header[collect.size()]);
    }


}
