package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.Action;
import org.matrix.autotest.service.ActionService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 动作 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/actions")
@Api(tags = "对动作表action的基本操作")
public class ActionController {

    private final ActionService actionService;

    public ActionController(ActionService actionService) {
        this.actionService = actionService;
    }

    /**
     * 查询所有动作
     *
     * @return 查询到的所有动作
     */
    @ApiOperation(value = "查询所有动作")
    @GetMapping
    public List<Action> findAllAction() {
        return actionService.findAllAction();
    }

    /**
     * 根据id查询动作
     *
     * @param id 动作Id
     * @return 动作
     */
    @ApiOperation(value = "根据id查询动作")
    @GetMapping("/{id}")
    public Action findByIdAction(@PathVariable Integer id) {
        return actionService.findByIdAction(id);
    }

    /**
     * 添加动作
     *
     * @param action 动作
     * @return 添加的动作
     */
    @ApiOperation(value = "添加动作")
    @PostMapping
    public Action insertAction(@RequestBody Action action) {
        return actionService.insertAction(action);
    }

    /**
     * 修改动作
     *
     * @param action 动作
     * @return 修改后的动作
     */
    @ApiOperation(value = "根据id修改动作")
    @PutMapping("/{id}")
    public Action updateAction(@RequestBody Action action) {
        return actionService.updateAction(action);
    }

    /**
     * 删除动作
     *
     * @param action 动作
     * @return 删除的动作
     */
    @ApiOperation(value = "根据id删除动作")
    @DeleteMapping("/{id}")
    public Action deleteAction(@RequestBody Action action) {
        return actionService.deleteAction(action);
    }

}

