package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.DynamicVariable;
import org.matrix.autotest.service.DynamicVariableService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/dynamicVariables")
@Api(tags = "对动态变量表dynamic_variable的基本操作")
public class DynamicVariableController {

    private final DynamicVariableService dynamicVariableService;

    public DynamicVariableController(DynamicVariableService dynamicVariableService) {
        this.dynamicVariableService = dynamicVariableService;
    }

    /**
     * 查询所有动态变量
     *
     * @return 动态变量
     */
    @ApiOperation(value = "查询所有动态变量")
    @GetMapping
    public List<DynamicVariable> findAllDynamicVariable() {
        return dynamicVariableService.findAllDynamicVariable();
    }

    /**
     * 根据id查询动态变量
     *
     * @param id 动态变量Id
     * @return 动态变量
     */
    @ApiOperation(value = "根据id查询动态变量")
    @GetMapping("/{id}")
    public DynamicVariable findByIdDynamicVariable(@PathVariable Integer id) {
        return dynamicVariableService.findByIdDynamicVariable(id);
    }

    /**
     * 添加动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 添加的动态变量
     */
    @ApiOperation(value = "添加动态变量")
    @PostMapping
    public DynamicVariable insertDynamicVariable(@RequestBody DynamicVariable dynamicVariable) {
        return dynamicVariableService.insertDynamicVariable(dynamicVariable);
    }

    /**
     * 修改动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 修改后的动态变量
     */
    @ApiOperation(value = "根据id修改动态变量")
    @PutMapping("/{id}")
    public DynamicVariable updateDynamicVariable(@RequestBody DynamicVariable dynamicVariable) {
        return dynamicVariableService.updateDynamicVariable(dynamicVariable);
    }

    /**
     * 删除动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 删除的动态变量
     */
    @ApiOperation(value = "根据id删除动态变量")
    @DeleteMapping("/{id}")
    public DynamicVariable deleteDynamicVariable(@RequestBody DynamicVariable dynamicVariable) {
        return dynamicVariableService.deleteDynamicVariable(dynamicVariable);
    }
}

