package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.Example;
import org.matrix.autotest.service.ExampleService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/examples")
@Api(tags = "对实例表example的基本操作")
public class ExampleController {

    private final ExampleService exampleService;

    public ExampleController(ExampleService exampleService) {
        this.exampleService = exampleService;
    }

    /**
     * 查询所有实例
     *
     * @return 实例
     */
    @ApiOperation(value = "查询所有实例")
    @GetMapping
    public List<Example> findAllExample() {
        return exampleService.findAllExample();
    }

    /**
     * 根据id查询实例
     *
     * @param id 实例Id
     * @return 实例
     */
    @ApiOperation(value = "根据id查询实例")
    @GetMapping("/{id}")
    public Example findByIdExample(@PathVariable Integer id) {
        return exampleService.findByIdExample(id);
    }

    /**
     * 添加实例
     *
     * @param example 实例
     * @return 添加的实例
     */
    @ApiOperation(value = "添加实例")
    @PostMapping
    public Example insertExample(@RequestBody Example example) {
        return exampleService.insertExample(example);
    }

    /**
     * 修改实例
     *
     * @param example 实例
     * @return 修改后的实例
     */
    @ApiOperation(value = "根据id修改实例")
    @PutMapping("/{id}")
    public Example updateExample(@RequestBody Example example) {
        return exampleService.updateExample(example);
    }

    /**
     * 删除实例
     *
     * @param example 实例
     * @return 删除的实例
     */
    @ApiOperation(value = "根据id删除实例")
    @DeleteMapping("/{id}")
    public Example deleteExample(@RequestBody Example example) {
        return exampleService.deleteExample(example);
    }
}

