package org.matrix.autotest.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "实例表")
@TableName(value = "example")
public class Example {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 实例名称
     */
    @ApiModelProperty(value = "实例名称")
    private String name;

    /**
     * 参数名 （例如：env）
     */
    @ApiModelProperty(value = "参数名 （例如：env）")
    private String parameterName;

    /**
     * 项目ID
     */
    @ApiModelProperty(value = "项目ID")
    private Integer projectId;

    /**
     * 静态变量，以JSON的形式存储，例如（{"name":"张三"}）
     */
    @ApiModelProperty(value = "静态变量，以JSON的形式存储，例如（{\"name\":\"张三\"}）")
    private String variable;

    /**
     * ip,例如（http:www.abc.com）
     */
    @ApiModelProperty(value = "ip,例如（http:www.abc.com）")
    private String ip;

    @ApiModelProperty(value = "添加时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;


}
