package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Example;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface ExampleService extends IService<Example> {
    /**
     * 查询所有实例
     *
     * @return 实例
     */
    List<Example> findAllExample();

    /**
     * 根据id查询实例
     *
     * @param id 实例id
     * @return 实例
     */
    Example findByIdExample(Integer id);

    /**
     * 添加实例
     *
     * @param example 实例
     * @return 添加的实例
     */
    Example insertExample(Example example);

    /**
     * 修改实例
     *
     * @param example 实例
     * @return 修改后的实例
     */
    Example updateExample(Example example);

    /**
     * 删除实例
     *
     * @param example 实例
     * @return 删除的实例
     */
    Example deleteExample(Example example);
}
